package pt.cff.tp05_02;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import androidx.activity.result.ActivityResult;
import androidx.activity.result.ActivityResultCallback;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.appcompat.app.AppCompatActivity;

public class MainActivity extends AppCompatActivity {

    private static final int REQUEST_CODE_1 = 1;
    private TextView tv;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        tv=(TextView)findViewById(R.id.textView);
        Button button1 = (Button)findViewById(R.id.button1);
        button1.setOnClickListener(new View.OnClickListener(){
            public void onClick(View arg0) {
                String message = "AC/DC is the best rock band of all times!";
                int id= 50;
                Intent intent=new Intent(MainActivity.this,MainActivity2.class);
                intent.putExtra("EXTRA_MESSAGE", message);
                intent.putExtra("EXTRA_ID", id);
                startActivity(intent);
            }
        });
        Button button2 = (Button)findViewById(R.id.button2);
        button2.setOnClickListener(new View.OnClickListener(){
            public void onClick(View arg0) {
                Intent intent=new Intent(MainActivity.this,MainActivity3.class);
                ///Deprecated in API 31
                startActivityForResult(intent,REQUEST_CODE_1);
            }
        });

        ActivityResultLauncher<Intent> mainActivity4Launcher = registerForActivityResult(
                new ActivityResultContracts.StartActivityForResult(),
                new ActivityResultCallback<ActivityResult>() {
                    @Override
                    public void onActivityResult(ActivityResult result) {
                        if (result.getResultCode() == Activity.RESULT_OK) {
                            // There are no need for request codes
                            Intent data = result.getData();
                            String msg = data.getStringExtra("EXTRA_MESSAGE");
                            tv.setText("The message received from MainActivity4:\n\t" + msg);
                        }
                    }
                });

        Button button3 = (Button)findViewById(R.id.button3);
        button3.setOnClickListener(new View.OnClickListener() {
            public void onClick(View arg0) {
                Intent i = new Intent(MainActivity.this, MainActivity4.class);
                mainActivity4Launcher.launch(i);
            }
        });

        Button button4 = (Button)findViewById(R.id.button4);
        button4.setOnClickListener(new View.OnClickListener() {
            public void onClick(View arg0) {
                try {
                  Intent intent = new Intent(Intent.ACTION_DIAL, Uri.parse("tel:555-2368"));
                   startActivity(intent);
                }catch(ActivityNotFoundException ex){
                    tv.setText("Não foi possivel invocar activity externa para a acção Intent.ACTION_DIAL:" +  ex.getLocalizedMessage());
                }
            }
        });
    }


    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        TextView tv=(TextView)findViewById(R.id.textView);
        if(data!=null){
            switch(requestCode){
                case REQUEST_CODE_1:
                    if(resultCode == Activity.RESULT_OK){
                        int id = data.getIntExtra("EXTRA_ID",0);
                        tv.setText("Integer received from MainActivity3:" + id);
                    }
                    break;
            }
        }
    }

}
